# PHP SQLite Book Manager

Simple PHP web app to manage books (SQLite backend).

Features
- SQLite database (data/books.db)
- Table `books` (id, name, author, description, image, link)
- Admin user (created during setup)
- Public pages:
  - index.php — list all books with search
  - book.php — book description/detail page
- Admin pages:
  - admin/login.php, admin/dashboard.php, admin/add_edit.php, admin/delete.php, admin/logout.php
- Image uploads stored in `uploads/`

Quick start (PHP built-in server)
1. Clone/copy the files to a directory on your machine.
2. From the project root run the setup once:
   - `php setup.php`
   This creates `data/books.db` and the `uploads/` folder and inserts a sample admin and a sample book.
3. Start the built-in server (serve the `public/` directory):
   - `php -S localhost:8000 -t public`
4. Open http://localhost:8000 in your browser.

Admin credentials (created by setup.php)
- username: `admin`
- password: `admin123`

Notes
- Change the admin password after setup using the admin edit form or update directly in the DB.
- Make sure `data/` and `uploads/` are writable by PHP.
- This is a simple demo app. For production, add CSRF protection, stronger authentication, input validation, and restrict upload types/size more strictly.