<?php
require_once __DIR__ . '/../../config.php';
if (!isAdmin()) {
    header("Location: /admin/login.php");
    exit;
}
$pdo = getPDO();

$editing = false;
$book = ['id'=>null,'name'=>'','author'=>'','description'=>'','image'=>'','link'=>''];

if (isset($_GET['id']) && ctype_digit($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM books WHERE id = :id");
    $stmt->execute([':id'=>$_GET['id']]);
    $r = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($r) {
        $editing = true;
        $book = $r;
    }
}

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $author = trim($_POST['author'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $link = trim($_POST['link'] ?? '');
    $currentImage = $_POST['current_image'] ?? '';

    if ($name === '') $err = "Name is required.";

    // handle upload
    $uploadedFilename = $currentImage;
    if (!empty($_FILES['image']['name'])) {
        $file = $_FILES['image'];
        if ($file['error'] === UPLOAD_ERR_OK) {
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg','jpeg','png','gif','webp'];
            if (!in_array($ext, $allowed)) {
                $err = "Unsupported image type.";
            } else {
                $safe = bin2hex(random_bytes(8)) . '.' . $ext;
                $dst = __DIR__ . '/../uploads/' . $safe;
                if (!move_uploaded_file($file['tmp_name'], $dst)) {
                    $err = "Failed to move uploaded file.";
                } else {
                    $uploadedFilename = $safe;
                }
            }
        } else {
            $err = "Upload error.";
        }
    }

    if ($err === '') {
        if (!empty($_POST['id'])) {
            // update
            $stmt = $pdo->prepare("UPDATE books SET name=:n, author=:a, description=:d, image=:i, link=:l WHERE id=:id");
            $stmt->execute([
                ':n'=>$name, ':a'=>$author, ':d'=>$description, ':i'=>$uploadedFilename, ':l'=>$link, ':id'=>$_POST['id']
            ]);
            header("Location: /admin/dashboard.php");
            exit;
        } else {
            $stmt = $pdo->prepare("INSERT INTO books (name, author, description, image, link) VALUES (:n,:a,:d,:i,:l)");
            $stmt->execute([':n'=>$name, ':a'=>$author, ':d'=>$description, ':i'=>$uploadedFilename, ':l'=>$link]);
            header("Location: /admin/dashboard.php");
            exit;
        }
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?= $editing ? 'Edit' : 'Add' ?> Book</title>
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>
  <main>
    <h1><?= $editing ? 'Edit' : 'Add' ?> Book</h1>
    <?php if ($err): ?><p class="error"><?=htmlspecialchars($err)?></p><?php endif; ?>
    <form method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?= htmlspecialchars($book['id']) ?>">
      <label>Name<br><input name="name" value="<?=htmlspecialchars($book['name'])?>" required></label><br>
      <label>Author<br><input name="author" value="<?=htmlspecialchars($book['author'])?>"></label><br>
      <label>Description<br><textarea name="description"><?=htmlspecialchars($book['description'])?></textarea></label><br>
      <label>External link<br><input name="link" value="<?=htmlspecialchars($book['link'])?>"></label><br>
      <?php if (!empty($book['image']) && file_exists(__DIR__ . '/../uploads/' . $book['image'])): ?>
        <p>Current image:<br><img src="/uploads/<?=htmlspecialchars($book['image'])?>" alt="" style="max-width:200px"></p>
        <input type="hidden" name="current_image" value="<?=htmlspecialchars($book['image'])?>">
      <?php else: ?>
        <input type="hidden" name="current_image" value="">
      <?php endif; ?>
      <label>Upload image (jpg, png, gif, webp)<br><input type="file" name="image" accept="image/*"></label><br>
      <button type="submit"><?= $editing ? 'Update' : 'Add' ?> Book</button>
    </form>
    <p><a href="/admin/dashboard.php">Back to dashboard</a></p>
  </main>
</body>
</html>