<?php
require_once __DIR__ . '/../../config.php';
if (!isAdmin()) {
    header("Location: /admin/login.php");
    exit;
}
$pdo = getPDO();
$stmt = $pdo->query("SELECT * FROM books ORDER BY id DESC");
$books = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Admin Dashboard</title>
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>
  <header>
    <h1>Admin Dashboard</h1>
    <nav><a href="/admin/logout.php">Logout</a> | <a href="/">View Catalog</a></nav>
  </header>
  <main>
    <p><a href="/admin/add_edit.php">Add new book</a></p>
    <table class="admin-table">
      <thead><tr><th>#</th><th>Name</th><th>Author</th><th>Actions</th></tr></thead>
      <tbody>
      <?php foreach ($books as $b): ?>
        <tr>
          <td><?= $b['id'] ?></td>
          <td><?=htmlspecialchars($b['name'])?></td>
          <td><?=htmlspecialchars($b['author'])?></td>
          <td>
            <a href="/admin/add_edit.php?id=<?= $b['id'] ?>">Edit</a> |
            <a href="/admin/delete.php?id=<?= $b['id'] ?>" onclick="return confirm('Delete this book?')">Delete</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </main>
</body>
</html>