<?php
require_once __DIR__ . '/../../config.php';
if (!isAdmin()) {
    header("Location: /admin/login.php");
    exit;
}
if (!isset($_GET['id']) || !ctype_digit($_GET['id'])) {
    header("Location: /admin/dashboard.php");
    exit;
}
$id = (int)$_GET['id'];
$pdo = getPDO();
$stmt = $pdo->prepare("SELECT image FROM books WHERE id = :id");
$stmt->execute([':id' => $id]);
$book = $stmt->fetch(PDO::FETCH_ASSOC);
if ($book) {
    if (!empty($book['image'])) {
        $f = __DIR__ . '/../uploads/' . $book['image'];
        if (file_exists($f)) @unlink($f);
    }
    $del = $pdo->prepare("DELETE FROM books WHERE id = :id");
    $del->execute([':id' => $id]);
}
header("Location: /admin/dashboard.php");
exit;