<?php
require_once __DIR__ . '/../../config.php';

$pdo = getPDO();
$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if ($username === '' || $password === '') {
        $err = "Enter username and password.";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM admin WHERE username = :u LIMIT 1");
        $stmt->execute([':u' => $username]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['is_admin'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            header("Location: /admin/dashboard.php");
            exit;
        } else {
            $err = "Invalid credentials.";
        }
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Admin Login</title>
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>
  <main class="auth">
    <h1>Admin Login</h1>
    <?php if ($err): ?><p class="error"><?=htmlspecialchars($err)?></p><?php endif; ?>
    <form method="post" action="">
      <label>Username<br><input name="username" required></label><br>
      <label>Password<br><input name="password" type="password" required></label><br>
      <button type="submit">Login</button>
    </form>
    <p><a href="/">Back to catalog</a></p>
  </main>
</body>
</html>