<?php
require_once __DIR__ . '/../config.php';

if (!isset($_GET['id']) || !ctype_digit($_GET['id'])) {
    header("HTTP/1.1 400 Bad Request");
    echo "Invalid book id";
    exit;
}
$id = (int)$_GET['id'];
$pdo = getPDO();
$stmt = $pdo->prepare("SELECT * FROM books WHERE id = :id");
$stmt->execute([':id' => $id]);
$book = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$book) {
    header("HTTP/1.1 404 Not Found");
    echo "Book not found";
    exit;
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?=htmlspecialchars($book['name'])?> — Book</title>
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>
  <header>
    <h1><?=htmlspecialchars($book['name'])?></h1>
    <nav><a href="/">Back to catalog</a> | <a href="/admin/login.php">Admin</a></nav>
  </header>
  <main>
    <div class="book-detail">
      <?php if (!empty($book['image']) && file_exists(__DIR__ . '/uploads/' . $book['image'])): ?>
        <img src="/uploads/<?=htmlspecialchars($book['image'])?>" alt="">
      <?php endif ?>
      <p><strong>Author:</strong> <?=htmlspecialchars($book['author'])?></p>
      <p><?=nl2br(htmlspecialchars($book['description']))?></p>
      <?php if (!empty($book['link'])): ?>
        <p><a href="<?=htmlspecialchars($book['link'])?>" target="_blank" rel="noopener">External link</a></p>
      <?php endif ?>
    </div>
  </main>
</body>
</html>