<?php
require_once __DIR__ . '/../config.php';

$pdo = getPDO();

$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$params = [];
$sql = "SELECT * FROM books";
if ($q !== '') {
    $sql .= " WHERE name LIKE :q OR author LIKE :q";
    $params[':q'] = "%$q%";
}
$sql .= " ORDER BY id DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$books = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Book Catalog</title>
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>
  <header>
    <h1>Book Catalog</h1>
    <nav><a href="/admin/login.php">Admin</a></nav>
  </header>
  <main>
    <form method="get" action="/">
      <input type="search" name="q" placeholder="Search by name or author" value="<?=htmlspecialchars($q)?>">
      <button type="submit">Search</button>
      <?php if ($q !== ''): ?>
        <a href="/">clear</a>
      <?php endif ?>
    </form>

    <div class="grid">
      <?php foreach ($books as $book): ?>
        <article class="book-card">
          <?php if (!empty($book['image']) && file_exists(__DIR__ . '/uploads/' . $book['image'])): ?>
            <img src="/uploads/<?=htmlspecialchars($book['image'])?>" alt="">
          <?php else: ?>
            <div class="placeholder">No image</div>
          <?php endif ?>
          <h2><a href="/book.php?id=<?= $book['id'] ?>"><?=htmlspecialchars($book['name'])?></a></h2>
          <p class="author"><?=htmlspecialchars($book['author'])?></p>
          <p class="desc"><?=nl2br(htmlspecialchars(substr($book['description'],0,150)))?><?php if (strlen($book['description'])>150) echo '...'; ?></p>
          <p><a href="/book.php?id=<?= $book['id'] ?>">Details</a></p>
        </article>
      <?php endforeach; ?>
    </div>
  </main>
</body>
</html>