<?php
// Run once to create database, admin user, and a sample book.
// Usage: php setup.php
echo "Running setup...\n";

$root = __DIR__;
$dataDir = $root . DIRECTORY_SEPARATOR . 'data';
$dbFile = $dataDir . DIRECTORY_SEPARATOR . 'books.db';
$uploadsDir = $root . DIRECTORY_SEPARATOR . 'public' . DIRECTORY_SEPARATOR . 'uploads';

if (!is_dir($dataDir)) {
    mkdir($dataDir, 0755, true);
    echo "Created data/ directory\n";
}

if (!is_dir($uploadsDir)) {
    mkdir($uploadsDir, 0755, true);
    echo "Created public/uploads/ directory\n";
}

if (file_exists($dbFile)) {
    echo "Database already exists at $dbFile — skipping creation.\n";
    exit(0);
}

$dsn = "sqlite:$dbFile";
$pdo = new PDO($dsn);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$pdo->exec("
CREATE TABLE admin (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT UNIQUE NOT NULL,
    password TEXT NOT NULL
);
");

$pdo->exec("
CREATE TABLE books (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    author TEXT,
    description TEXT,
    image TEXT,
    link TEXT
);
");

$adminUser = 'admin';
$adminPass = password_hash('admin123', PASSWORD_DEFAULT);
$stmt = $pdo->prepare("INSERT INTO admin (username, password) VALUES (:u, :p)");
$stmt->execute([':u' => $adminUser, ':p' => $adminPass]);
echo "Created admin user 'admin' with password 'admin123'. Please change after login.\n";

// Insert a sample book
$stmt = $pdo->prepare("INSERT INTO books (name, author, description, image, link) VALUES (:n, :a, :d, :i, :l)");
$stmt->execute([
    ':n' => 'Sample Book',
    ':a' => 'Jane Doe',
    ':d' => 'This is a sample book inserted by setup.',
    ':i' => null,
    ':l' => 'https://example.com'
]);
echo "Inserted a sample book.\n";

echo "Setup complete. Start server: php -S localhost:8000 -t public\n";